/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance;

import java.util.HashMap;
import java.util.Map;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.definition.process.Process;
import org.drools.definition.process.WorkflowProcess;
import org.drools.runtime.KnowledgeRuntime;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowProcessInstanceUpgrader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upgradeProcessInstance(KnowledgeRuntime kruntime, long processInstanceId, String processId, Map<String, Long> nodeMapping) {
        WorkflowProcessInstanceImpl processInstance;
        if (nodeMapping == null) {
            nodeMapping = new HashMap<String, Long>();
        }
        if ((processInstance = (WorkflowProcessInstanceImpl)kruntime.getProcessInstance(processInstanceId)) == null) {
            throw new IllegalArgumentException("Could not find process instance " + processInstanceId);
        }
        if (processId == null) {
            throw new IllegalArgumentException("Null process id");
        }
        WorkflowProcess process = (WorkflowProcess)kruntime.getKnowledgeBase().getProcess(processId);
        if (process == null) {
            throw new IllegalArgumentException("Could not find process " + processId);
        }
        if (processInstance.getProcessId().equals(processId)) {
            return;
        }
        WorkflowProcessInstanceImpl workflowProcessInstanceImpl = processInstance;
        synchronized (workflowProcessInstanceImpl) {
            Process oldProcess = processInstance.getProcess();
            processInstance.disconnect();
            processInstance.setProcess(oldProcess);
            WorkflowProcessInstanceUpgrader.updateNodeInstances(processInstance, nodeMapping);
            processInstance.setKnowledgeRuntime((InternalKnowledgeRuntime)kruntime);
            processInstance.setProcess(process);
            processInstance.reconnect();
        }
    }

    private static void updateNodeInstances(NodeInstanceContainer nodeInstanceContainer, Map<String, Long> nodeMapping) {
        for (org.drools.runtime.process.NodeInstance nodeInstance : nodeInstanceContainer.getNodeInstances()) {
            String oldNodeId = ((NodeImpl)((NodeInstance)nodeInstance).getNode()).getUniqueId();
            Long newNodeId = nodeMapping.get(oldNodeId);
            if (newNodeId == null) {
                newNodeId = nodeInstance.getNodeId();
            }
            ((NodeInstanceImpl)nodeInstance).setNodeId(newNodeId);
            if (!(nodeInstance instanceof NodeInstanceContainer)) continue;
            WorkflowProcessInstanceUpgrader.updateNodeInstances((NodeInstanceContainer)((Object)nodeInstance), nodeMapping);
        }
    }
}

